from sqlalchemy import Column, Integer, String
from .database import Base

class User(Base):
    __tablename__ = "users"
    id = Column(Integer, primary_key=True)
    email = Column(String(100), unique=True, index=True)  # varchar(100)
    password = Column(String(100))  # varchar(100)

class Registration(Base):
    __tablename__ = "registrations"
    id = Column(Integer, primary_key=True, index=True)
    cname = Column(String(100))
    husband_name = Column(String(100))
    address = Column(String(200))
    education = Column(String(100))
    dob = Column(String(20))  # store as string YYYY-MM-DD
    mobile = Column(String(15))
    email = Column(String(100))
    adhar = Column(String(20))
    adhar_front = Column(String(255))  # file path
    adhar_back = Column(String(255))
    marksheet = Column(String(255))

class Notification(Base):
    __tablename__ = "notifications"
    id = Column(Integer, primary_key=True, index=True)
    title = Column(String(200))
    message = Column(String(1000))
    created_at = Column(String(30))

class Subscriber(Base):
    __tablename__ = "subscribers"
    id = Column(Integer, primary_key=True, index=True)
    email = Column(String(100), unique=True)

class Contact(Base):
    __tablename__ = "contacts"
    id = Column(Integer, primary_key=True, index=True)
    name = Column(String(100))
    email = Column(String(100))
    subject = Column(String(200))
    message = Column(String(1000))
