from sqlalchemy.orm import Session
from . import models, schemas
from passlib.hash import bcrypt
from datetime import datetime

def create_user(db: Session, user: schemas.UserCreate):
    hashed_pw = bcrypt.hash(user.password)
    db_user = models.User(email=user.email, password=hashed_pw)
    db.add(db_user)
    db.commit()
    db.refresh(db_user)
    return db_user

def authenticate_user(db: Session, email: str, password: str):
    user = db.query(models.User).filter(models.User.email == email).first()
    if user and bcrypt.verify(password, user.password):
        return user
    return None

def save_registration(db: Session, reg: schemas.RegistrationBase, files: dict):
    reg_data = models.Registration(
        **reg.dict(),
        adhar_front=files["adhar_front"],
        adhar_back=files["adhar_back"],
        marksheet=files["marksheet"]
    )
    db.add(reg_data)
    db.commit()
    db.refresh(reg_data)
    return reg_data

def get_all_registrations(db: Session):
    return db.query(models.Registration).all()


def create_notification(db: Session, notif: schemas.NotificationCreate):
    db_notif = models.Notification(
        title=notif.title,
        message=notif.message,
        created_at=datetime.utcnow().strftime("%Y-%m-%d %H:%M")
    )
    db.add(db_notif)
    db.commit()
    db.refresh(db_notif)
    return db_notif

def add_subscriber(db: Session, email: str):
    existing = db.query(models.Subscriber).filter(models.Subscriber.email == email).first()
    if not existing:
        db_email = models.Subscriber(email=email)
        db.add(db_email)
        db.commit()
        db.refresh(db_email)
        return db_email
    return existing

def get_all_subscribers(db: Session):
    return db.query(models.Subscriber).all()

def create_contact(db: Session, contact: schemas.ContactCreate):
    db_contact = models.Contact(**contact.dict())
    db.add(db_contact)
    db.commit()
    db.refresh(db_contact)
    return db_contact

def get_all_notifications(db: Session):
    return db.query(models.Notification).all()

def get_all_contacts(db: Session):
    return db.query(models.Contact).all()
