from pydantic import BaseModel, EmailStr

class UserCreate(BaseModel):
    email: EmailStr
    password: str

class UserLogin(BaseModel):
    email: EmailStr
    password: str

class RegistrationBase(BaseModel):
    cname: str
    husband_name: str
    address: str
    education: str
    dob: str
    mobile: str
    email: EmailStr
    adhar: str

class NotificationCreate(BaseModel):
    title: str
    message: str

class SubscriberCreate(BaseModel):
    email: EmailStr

class ContactCreate(BaseModel):
    name: str
    email: EmailStr
    subject: str
    message: str
